rm(list = ls())
source("_funciones.txt")

datos = read.table("Wissel.txt", header = T, sep=";")
head(datos)
attach(datos)

#

reg = lm(D~C+I+CP)
summary(reg)
beta = as.double(reg$coefficients)

x = cbind(C,I,CP)
FIV(x)

NC(x)
NC(cbind(array(1,length(D)),x))

#

reg.aux.1 = lm(C~I+CP)
summary(reg.aux.1)

FIV(cbind(I,CP))
NC(cbind(array(1,length(C)),I,CP))

reg.aux.2 = lm(I~C+CP)
summary(reg.aux.2)

FIV(cbind(C,CP))
NC(cbind(array(1,length(I)),C,CP))

reg.aux.3 = lm(CP~C+I)
summary(reg.aux.3)

FIV(cbind(C,I))
NC(cbind(array(1,length(CP)),C,I))

#

reg2 = lm(D~I+CP)
summary(reg2)

#

#install.packages("lrmest")
library(lrmest) # no me ofrece muchas garantas esta funcin

r = c(-5.0709, 1.709, -0.0006)
R = c(1, 2.478, 0, 0, 0, 0.331, 1, 0, 0, 0.0008, 0, 1)
delt = c(0, 0, 0) # mismas dimensiones que r
reg.rls = rls(D~C+I+CP, r, R, delt, data = datos)
reg.rls
beta.rls = as.matrix(reg.rls[[1]][,1])

#####################################################################################

tol = 0.01
media = 10
dv = 10

Cp = perturb(C, media, dv, tol)
mean(abs(C-Cp))

Ip = perturb(I, media, dv, tol)
mean(abs(I-Ip))

CPp = perturb(CP, media, dv, tol)
mean(abs(CP-CPp))


reg.p = lm(D~Cp+Ip+CPp)
summary(reg.p)
beta.p = as.double(reg.p$coefficients)

(norm(C-Cp,"2")/norm(C,"2"))*100
(norm(I-Ip,"2")/norm(I,"2"))*100
(norm(CP-CPp,"2")/norm(CP,"2"))*100
(norm(beta-beta.p,"2")/norm(beta,"2"))*100

Xp = cbind(D,C,I,CP,Cp,Ip,CPp)
write(t(Xp), "Wissel-completo-perturbado.txt", ncolumns = 7, sep=";")

#

r = c(-5.0709, 1.709, -0.0006)
R = c(1, 2.478, 0, 0, 0, 0.331, 1, 0, 0, 0.0008, 0, 1)
delt = c(0, 0, 0) # mismas dimensiones que r
reg.rls.p = rls(D~Cp+Ip+CPp, r, R, delt, data = datos)
reg.rls.p
beta.rls.p = as.matrix(reg.rls.p[[1]][,1])

(norm(beta.rls-beta.rls.p,"2")/norm(beta.rls,"2"))*100
























#############################################################################
# restriccin para la constante

r = c(-5.0709, 1.709, -0.0006, mean(D))
R = c(1, 2.478, 0, 0, 0, 0.331, 1, 0, 0, 0.0008, 0, 1, 1, 0, 0, 0)
delt = c(0, 0, 0, 0) # mismas dimensiones que r

reg.rls = rls(D~C+I+CP, r, R, delt, data = datos)
reg.rls
beta.rls = as.matrix(reg.rls[[1]][,1])

reg.rls.p = rls(D~Cp+Ip+CPp, r, R, delt, data = datos)
reg.rls.p
beta.rls.p = as.matrix(reg.rls.p[[1]][,1])

(norm(beta.rls-beta.rls.p,"2")/norm(beta.rls,"2"))*100


detach(datos)










#################################################################################################
# recupero info

datos = read.table("Wissel-completo-perturbado.txt", header=T,  sep=";")
head(datos)
attach(datos)

reg = lm(D~C+I+CP)
summary(reg)
beta = as.double(reg$coefficients)

reg.p = lm(D~Cp+Ip+CPp)
summary(reg.p)
beta.p = as.double(reg.p$coefficients)

(norm(C-Cp,"2")/norm(C,"2"))*100
(norm(I-Ip,"2")/norm(I,"2"))*100
(norm(CP-CPp,"2")/norm(CP,"2"))*100
(norm(beta-beta.p,"2")/norm(beta,"2"))*100

detach(datos)

beta.bis = c(6.762459, -4.775367, 3.289646, 0.003220294)
(norm(beta-beta.bis,"2")/norm(beta,"2"))*100
